/*---------------------------------------------------------------------------+
| PMSPY.C                                                                    |
+----------------------------------------------------------------------------+
|                                                                            |
| Program to spy on other windows message queues                             |
|                                                                            |
+-------------------------------------+--------------------------------------+
|                                     |   Steve Diering (DIERING at RALVM14) |
| Version: 0.05                       |   Research Triangle Park, NC         |
+-------------------------------------+--------------------------------------+
|                                     |   Juerg von Kaenel (JVK at ZURLVM1)  |
| Version: 1.10                       |   IBM Research Laboratory            |
|                                     |   Saeumerstrasse 4                   |
|                                     |   CH - 8803 Rueschlikon              |
|                                     |   Switzerland                        |
+-------------------------------------+--------------------------------------+
| History:                                                                   |
| --------                                                                   |
|                                                                            |
| created: jan  6 1989 by J. von Kaenel                                      |
| updated: jan 21 1989 by J. von Kaenel - added support for 2 simultaneous   |
|                                         instances of PMSPY                 |
| updated: jun 13 1989 by J. von Kaenel - did some clean ups                 |
| $C1=1.10,06/24/89,jvk,added command line parameter support                 |
+---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------+
| Includes                                                                   |
+---------------------------------------------------------------------------*/

#define DEFINE_VARIABLES

#define INCL_DOSPROCESS                 /* need DosExitList stuff.... */

#include "pmspy.h"                      /* Resource symbolic identifiers*/

/*---------------------------------------------------------------------------+
| ExitListRoutine
|
| - this routine is called during OS/2 exit list processing.  it is where
|   ALL housekeeping/cleanup occurs...
|
+---------------------------------------------------------------------------*/

VOID pascal far ExitListRoutine( USHORT ExitReason )

{
  SpyDeRegister( SpyInstance );       // De-Register with our DLL

  if ( hSwitch != NULL )
     WinRemoveSwitchEntry(hSwitch);

  if ( hwndFrame != NULL )
    WinDestroyWindow(hwndFrame);

  if ( hmq != NULL )
    WinDestroyMsgQueue(hmq);

  if ( hSpyDll != NULL )
    DosFreeModule(hSpyDll);

  if ( hab != NULL )
    WinTerminate(hab);

  DosExitList(EXLST_EXIT, NULL);                /* Indicate "done" */
}

/*---------------------------------------------------------------------------+
| Main                                                                       |
+---------------------------------------------------------------------------*/

VOID cdecl main(int argc, char *argv[], char * envp[])              /* @C1C */
{
  register BOOL   get_another_msg;             /* control PM msg loop */
           QMSG   qmsg;

  register USHORT i,
                  length;
           CHAR   nlsString[256];
           ULONG  CtrlData = FCF_STANDARD ^ FCF_TASKLIST;

  static   CHAR   ClassName[] = "PM_Spy_Window";  // Window Class name

  /* First, establish our ExitList handler (just in case we crash!) */

  DosExitList(EXLST_ADD, ExitListRoutine);

  /*******************************************************************
  *
  *  Let's get SPYing...
  *
  *  Programming Note: we're using a DO...WHILE block to simplify
  *                    our logic, nesting, etc. that's required to
  *                    handle any errors we detect during initialization.
  *
  *                    all we need is a BREAK statement to bail out
  *                    of the DO...WHILE loop!
  *
  *******************************************************************/

  do
  {
    if ( (hab = WinInitialize(NULL)) == NULL )
      break;

    ArgC = argc;                                                      /* @C1C */
    ArgV = argv;                                                      /* @C1C */

    /* load all of our strings, once and for all */

    for (/* init */ i = 0, length = 1;
         /* term */ (i < IDS_TOTAL) && (length != 0);  /* Loop for all strings */
         /* iter */ i++) {
        /* Load the string into a local variable */
        if ( (length = WinLoadString(                     /* Load the string              */
                                      hab,                /*  Required anchor block handle*/
                                      NULL,               /*  Resource module             */
                                      i,                  /*  Resource ID                 */
                                      sizeof(nlsString),  /*  Max length                  */
                                      nlsString) )        /*  Addr of string buffer       */
             != 0) {
          /* duplicate string for subsequent use */
          if ( ( Strings[i] = strdup( nlsString)) == NULL)                           /*  Addr of string buffer       */
            length = 0;   /* fail if unable to DUP it... */
        } /* endif */
    } /* endfor */

    if (length == 0)                                     /* Error in Loop                */
      break;

    /* Initialize SPY data for Processing */

    InitializeSpyData(&spyData);

    if ( (hmq = WinCreateMsgQueue(hab, atoi(Strings[IDS_MAX_PM_Q_SIZE]))) == NULL)
      break;

    if (DosLoadModule(NULL, 0, Strings[IDS_DLL_NAME], &hSpyDll) != 0 )
      break;

    WinRegisterClass(                   /* Register Window Class        */
                     hab,                            /* Anchor block handle          */
                     ClassName,                      /* Window Class name            */
                     (PFNWP)SpyWindowProc,           /* Address of Window Procedure  */
                     CS_SIZEREDRAW,                  /* No special class style       */
                     0);                             /* No extra window words        */

    hwndFrame = WinCreateStdWindow((HWND)HWND_DESKTOP,       /* Desktop Window is parent     */
                                   FS_ICON,
                                   (PVOID) &CtrlData,
                                   ClassName,                /* Window Class name            */
                                   Strings[IDS_TITLE],
                                   NULL /*WS_VISIBLE*/,      /* Client style - visible       */
                                   NULL,                     /* Module handle                */
                                   (USHORT)ID_MAINWND,       /* Window ID                    */
                                   (HWND FAR *)&hwndClient); /* Client Window handle         */

    if (hwndFrame == NULL)
      break;

    /*******************************************************************
    *
    *  Our basic PM requirements are complete...time to register
    *  with our DLL resident support team
    *
    *******************************************************************/

    if ( SpyDllVersion() != DLLVERSION )   // compatible .DLL and .EXE?
    {
      MsgDisplay(HWND_DESKTOP,
                 Strings[IDS_TITLE],
                 Strings[IDS_FMT_LEVEL],
                 0,
                 MB_CUACRITICAL | MB_CANCEL,
                 DLLVERSION, SpyDllVersion());
      break;
    }

    // can we register?

    if ( (SpyInstance = SpyRegister(hwndFrame,hab,hSpyDll)) == SPY_BAD_SPYEE)
    {
      MsgDisplay(HWND_DESKTOP,
                 Strings[IDS_TITLE],
                 Strings[IDS_MSG_TOO_MANY_SPIES],
                 0,
                 MB_CUACRITICAL| MB_CANCEL,
                 SpyQueryDllRegisterMax() );
      break;
    }

    hSpy = WinLoadPointer(HWND_DESKTOP, NULL, ID_SPY_POINTER);

    sprintf(swcntrl.szSwtitle,
            Strings[IDS_FMT_TITLE],
            Strings[IDS_TITLE], SpyInstance + 1);

    WinSetWindowText(hwndFrame, swcntrl.szSwtitle);

    swcntrl.hwnd = hwndFrame;

    hSwitch = WinAddSwitchEntry((PSWCNTRL)&swcntrl);

    /* default to "Spying" on the queue */

    SpySetTargetIsWindow(SpyInstance, FALSE);

    /*<f>25*****************************************************************
    *
    * Process the PM Message queue
    *
    * - get the next Msg
    *
    ***********************************************************************/

    do
    {
      if (get_another_msg = WinGetMsg(hab,       /* Required anchor block */
                                      &qmsg,     /* Addr of msg structure */
                                      NULL,      /* Filter window (none)  */
                                      NULL,      /* Filter begin    "     */
                                      NULL)   )  /* Filter end      "     */

      /**********************************************************************
      *
      * is this our notice to ourself that we're really ready to Quit?
      *
      * if so,  leave 'get_another_msg' set FALSE
      * if not, leave 'get_another_msg' set TRUE  & dispatch to proper window
      *
      ***********************************************************************/

      {
        if (get_another_msg = (qmsg.msg != PMSPY_QUIT_NOTICE) )

          WinDispatchMsg( hab, &qmsg );
      } /* endif */

      /***********************************************************************
      *
      * we've got a WM_QUIT message....
      *
      * - it can only come from a Task Manager CLOSE operation
      *
      * - tell PM we're going to ignore this WM_QUIT
      *
      * - prompt the user to see if he really does want to terminate
      *   (done by simulating a EXIT menu item selection)
      *
      * Note: at this point, we know that 'get-another-msg' is FALSE...
      *
      ***********************************************************************/

      else
      {
        WinCancelShutdown(hmq, FALSE);           /* ignoring WM_QUIT */

        get_another_msg = TRUE;                  /* must get more MSGs! */

        WinPostMsg( hwndFrame,                   /* Window Handle */
                    WM_COMMAND,                  /* Message ID */
                    (MPARAM) ID_F_EXIT,          /* P1 = fake EXIT selection */
                    (MPARAM) NULL);              /* P2 = NONE */
      } /* endif */

    } while ( get_another_msg );                 /* obey what he says... */

   } while (TRUE == FALSE );      /* of course, this is ONLY ONCE thru loop! */

   /**** NOTE: all cleanup is now done in the ExitList routine... */

   DosExit(EXIT_PROCESS, 0);
}

/*--- end of file ----------------------------------------------------------*/
